package cn.com.duiba.live.clue.service.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallAfterSaleOrderDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/08/11 10:44
 * @description 商城 - 售后 RPC
 */
@AdvancedFeignClient
public interface RemoteMallAfterSaleOrderService {

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return 售后详情
     */
    MallAfterSaleOrderDto selectById(Long id);

    /**
     * 根据订单Id查询售后单列表
     *
     * @param orderId 订单id
     * @return 售后详情
     */
    List<MallAfterSaleOrderDto> listByOrderId(Long orderId);

    /**
     * 根据订单Id查询最近一条售后单
     *
     * @param orderId 订单id
     * @return 售后详情
     */
    MallAfterSaleOrderDto findRecentByOrderId(Long orderId);

    /**
     * 新增售后单
     *
     * @param dto 售后详情
     * @return 新增结果
     */
    int insert(MallAfterSaleOrderDto dto);

    /**
     * 更新物流单号, 同时流转状态
     * 5:等待上传单号 -> 6:等待商家收货
     *
     * @param id         主键
     * @param expressNum 物流单号
     * @return 更新结果
     */
    int updateExpressNum(Long id, String expressNum);

    /**
     * 更新售后单状态
     *
     * @param id        主键
     * @param oldStatus 老状态
     * @param newStatus 新状态
     * @return 执行结果
     */
    int updateStatusById(Long id, Integer oldStatus, Integer newStatus);

}