package cn.com.duiba.live.clue.service.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallOrderDetailDto;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallOrderDto;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallOrderListDto;
import cn.com.duiba.live.clue.service.api.param.mall.order.MallOrderSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 商城-订单相关
 *
 * @author xuzhigang
 * @date 2022/8/10 11:42 上午
 **/
@AdvancedFeignClient
public interface RemoteMallOrderService {
    /**
     * 根据id查询订单
     * @param id 主键id
     * @return 订单信息
     */
    MallOrderDto selectById(Long id);

    /**
     * 根据订单id查询订单详情
     *
     * @param orderId 订单id
     * @return 订单详情
     */
    MallOrderDetailDto findOrderDetail(Long orderId);

    /**
     * 查询订单列表
     *
     * @param param 查询订单列表参数
     * @return 订单列表
     */
    List<MallOrderListDto> findOrderList(MallOrderSearchParam param);

    /**
     * 根据订单号查询
     * @param orderNo 订单号
     * @return 订单信息
     */
    MallOrderDto selectByOrderNo(String orderNo);

    /**
     * 更新
     *
     * @param entity 订单数据
     * @return 执行结果
     */
    int update(MallOrderDto entity);

    /**
     * 新增
     * @param en 订单数据
     * @return 执行结果
     */
    int insert(MallOrderDto en);

    /**
     * 取消订单
     *
     * @param id id
     * @param cancelOrderReason 取消订单原因
     * @return 执行结果
     */
    int cancelOrder(Long id, String cancelOrderReason);

    /**
     * 确认订单
     *
     * @param id 订单id
     * @return 执行结果
     */
    int confirmOrder(Long id);

    /**
     * 更新自动确认收货时间
     * @param id 订单id
     * @param autoReceiveTime 自动确认收货时间
     * @return 执行结果
     */
    int updateAutoReceiveTime(Long id, Date autoReceiveTime);


    /**
     * 下单结果更新
     *
     * @param id 主键id
     * @param orderStatus 订单状态
     * @param prepayId 预付单号
     * @return 执行结果
     */
    int updateCreateOrderResult(Long id, Integer orderStatus, String prepayId);

    /**
     * 支付结果更新
     * @param id 主键id
     * @param orderStatus 订单状态
     * @param paidTime 支付时间
     * @param transactionId 支付单号
     * @return 执行结果
     */
    int updatePayResult(Long id, Integer orderStatus, Date paidTime, String transactionId);

    /**
     * 进入售后状态
     *
     * @param id 订单Id
     * @return 执行结果
     */
    int updateAfterSale(Long id);
}
