package cn.com.duiba.live.clue.service.api.dto.clue;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播宝箱领取实体
 * @author 吴文哲
 * @date 2021/4/12 10:19 上午
 **/
@Data
public class LiveTreasureReceiveDto implements Serializable {
    private static final long serialVersionUID = -8544038325020180231L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 直播访客id
     */
    private Long liveUserId;

    /**
     * '宝藏配置Id tb_live_pre_treasure_conf.id'
     */
    private Long treasureConfId;

    /**
     * 宝箱类型
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureTypeEnums
     */
    private Integer treasureType;

    /**
     * 宝箱配置关联id tb_live_treasure_conf_related.id
     */
    private Long confRelatedId;

    /**
     * 领取状态
     * {@link cn.com.duiba.live.clue.service.api.enums.clue.LiveTreasureReceiveStatusEnum}
     */
    private Integer receiveStatus;
}
