package cn.com.duiba.live.clue.service.api.param.clue;

import lombok.Data;

import java.io.Serializable;

/**
 * @author dugq
 * @date 2020-05-19
 */
@Data
public class LiveCLueRewardFindParam implements Serializable {

    private static final long serialVersionUID = -6950892450964632210L;
    /**
     * 直播ID，必填
     */
    private Long liveId;

    /**
     * 直播访客userId，必填
     */
    private Long liveVisitorId;

    /**
     * 奖励ID
     */
    private Long rewardId;

    /**
     * 奖励类型，必填：1-资料，2-关注直播间，3-累计观看，4-邀请好友，5-免费领，6-抢权益
     * @see cn.com.duiba.live.clue.service.api.enums.clue.LiveInteractTypeEnum
     */
    private Integer rewardType;

    /**
     * 直播互动配置id，对应tb_live_interact_conf.id
     */
    private Long confId;
}
