package cn.com.duiba.live.clue.service.api.remoteservice.mall.address;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.address.MallUserAddressDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/08/09 14:01
 * @description 商城 - 用户地址 RPC
 */
@AdvancedFeignClient
public interface RemoteMallUserAddressService {

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 地址详情
     */
    MallUserAddressDto selectById(Long id);

    /**
     * 根据用户id查询
     *
     * @param liveUserId 用户Id
     * @return 地址列表
     */
    List<MallUserAddressDto> listByLiveUserId(Long liveUserId);

    /**
     * 新增用户地址
     *
     * @param dto 地址详情
     * @return 执行结果
     */
    Long insert(MallUserAddressDto dto);

    /**
     * 更新用户地址
     *
     * @param dto 地址详情
     * @return 执行结果
     */
    Long update(MallUserAddressDto dto);

    /**
     * 设置默认地址 ( 同时修改当前默认地址的默认状态 )
     *
     * @param id         主键
     * @param liveUserId 用户Id
     * @return 执行结果
     */
    int setDefaultById(Long id, Long liveUserId);

    /**
     * 逻辑删除
     *
     * @param id 主键
     * @return 删除结果
     */
    int delete(Long id);
}