package cn.com.duiba.live.clue.service.api.remoteservice.mall.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.coupon.user.MallUserCouponDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMallUserCouponServiceApi {

    List<MallUserCouponDto> listUserCouponList(Long liveId, Long liveUserId);

    MallUserCouponDto selectUserCouponById(Long userCouponId);

    /**
     * 使用优惠券
     * @param userCouponId 用户优惠券ID
     * @return 是否扣除成功
     */
    Boolean usedCoupon(Long userCouponId);

    /**
     * 退还优惠券
     * @param userCouponId 用户优惠券ID
     * @return 是否退还成功
     */
    Boolean rollbackUserCoupon(Long userCouponId);
}
