package cn.com.duiba.live.clue.service.api.dto.mall.order;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 商城-订单表
 *
 * @author kjj mybatis generator
 * 2022-08-09
 */
@Data
public class MallOrderDto implements Serializable {
    private static final long serialVersionUID = 16600172809187614L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务id 业务类型为1时 直播id
     */
    private Long bizId;

    /**
     * 业务类型 1-直播
     */
    private Integer bizType;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 订单编号
     * max length = 64
     */
    private String bizOrderNo;

    /**
     * 订单状态 1-订单创建 2-微信收单失败 3-待支付 4-用户手动取消支付 5-超时自动取消支付 6-支付失败 7-发货待审核 8-发货审核失败 9-待发货 10-待收货 11-确认收货
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderStatusEnum}
     */
    private Integer orderStatus;

    /**
     * 订单总金额
     */
    private Integer orderAmount;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 微信预支付交易会话标识。用于后续接口调用中使用，该值有效期为2小时
     * max length = 40
     */
    private String prepayId;

    /**
     * 支付渠道1-微信支付
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.PayChannelEnum}
     */
    private Integer payChannel;

    /**
     * 售卖商品id，tb_mall_spu.id
     */
    private Long spuId;

    /**
     * 售卖规格库存单元id，tb_mall_sku.id
     */
    private Long skuId;

    /**
     * 支付过期时间
     */
    private Date expireTime;

    /**
     * 自动确认收货时间
     */
    private Date autoReceiveTime;

    /**
     * 购买数量
     */
    private Integer buyNum;

    /**
     * 买家留言
     */
    private String buyerMsg;

    /**
     * 支付单号
     * max length = 64
     */
    private String transactionId;

    /**
     * 发货审核拒绝原因
     * max length = 100
     */
    private String deliveryAuditReason;

    /**
     * 是否有售后 0-无 1-有
     */
    private Integer afterSale;

    /**
     * 支付时间
     */
    private Date paidTime;

    /**
     * 物流单号
     * max length = 32
     */
    private String expressNum;

    /**
     * 物流状态
     */
    private Integer expressState;

    /**
     * 物流公司
     */
    private String expressCompany;

    /**
     * 取消订单原因
     */
    private String cancelOrderReason;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * appId
     */
    private String appId;

    /**
     * 收货人手机号
     */
    private String receiverPhoneNum;

    /**
     * 发货时间
     */
    private Date deliveryTime;

    /**
     * 是否延迟过确认收货时间
     * 0-未确认 1-已确认
     */
    private Integer hasDelayedReceiveTime;
}