package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveTreasureReceiveDto;
import cn.com.duiba.live.clue.service.api.param.treasure.LiveTreasureUpdateStatusParam;

import java.util.List;

/**
 * 直播宝箱领取rpc接口
 * @author 吴文哲
 * @date 2021/4/12 10:25 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveTreasureReceiveApiService {

    /**
     * 保存宝箱领取记录
     *
     * @param receiveDto 宝箱领取记录dto
     * @return 保存结果
     */
    boolean insert(LiveTreasureReceiveDto receiveDto);

    /**
     * 批量保存宝箱领取记录
     *
     * @param insertList 宝箱领取记录dto列表
     * @return 保存结果
     */
    boolean batchInsert(List<LiveTreasureReceiveDto> insertList);

    /**
     * 根据id集合批量查询
     *
     * @param ids id集合
     * @return 领取记录
     */
    List<LiveTreasureReceiveDto> selectByIds(List<Long> ids);

    /**
     * 根据用户id集合和宝箱配置关联id批量查询开箱成功的记录
     *
     * @param liveUserIds 直播用户id集合
     * @param confRelatedId 宝箱关联id
     * @return 领取记录
     */
    List<LiveTreasureReceiveDto> selectOpenSuccess(List<Long> liveUserIds, Long confRelatedId);

    /**
     * 批量更新领取状态
     *
     * @param updateList 更新参数集合
     * @return 执行结果
     */
    int batchUpdateReceiveStatus(List<LiveTreasureUpdateStatusParam> updateList);
}