package cn.com.duiba.live.clue.service.api.bean.mall.order;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author hall
 * @date 2022-08-19 16:28
 * @description 商城 - 协商记录Ext信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class NegotiationExtInfoBean implements Serializable {

    private static final long serialVersionUID = -3295990244877824295L;

    /**
     * 售后原因
     */
    private String afterSaleReason;

    /**
     * 补充描述
     */
    private String additionalDesc;

    /**
     * 联系电话
     */
    private String phoneNum;

    /**
     * 退货单号, 仅当售后类型为退货退款时才需要
     */
    private String returnExpressNum;

    /**
     * 售后拒绝原因
     */
    private String afterSaleRejectReason;

    /**
     * 退款金额
     */
    private Integer refundAmount;

    /**
     * 申请售后
     */
    public static NegotiationExtInfoBean afterSaleApply(String afterSaleReason, String additionalDesc, String phoneNum) {
        return NegotiationExtInfoBean.builder()
                .afterSaleReason(afterSaleReason)
                .additionalDesc(additionalDesc)
                .phoneNum(phoneNum)
                .build();
    }

    /**
     * 用户上传退货单号
     */
    public static NegotiationExtInfoBean userUploadExpress(String returnExpressNum) {
        return NegotiationExtInfoBean.builder()
                .returnExpressNum(returnExpressNum)
                .build();
    }

    /**
     * 商家拒绝
     */
    public static NegotiationExtInfoBean merchantReject(String afterSaleRejectReason) {
        return NegotiationExtInfoBean.builder()
                .afterSaleRejectReason(afterSaleRejectReason)
                .build();
    }

    /**
     * 完成退款
     */
    public static NegotiationExtInfoBean finishRefund(Integer refundAmount) {
        return NegotiationExtInfoBean.builder()
                .refundAmount(refundAmount)
                .build();
    }

}