package cn.com.duiba.live.clue.service.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/08/11 10:44
 * @description 商城 - 售后状态枚举
 * @see <a href="http://cf.dui88.com/download/attachments/155691938/image2022-8-11_10-40-38.png?version=1&modificationDate=1660185638901&api=v2"/>
 */
@Getter
@AllArgsConstructor
public enum MallAfterSaleStatusEnum {

    WAIT_AUDIT(1, "等待审核"),
    AUDIT_SUCCESS(2, "审核成功"),
    AUDIT_FAIL(3, "审核拒绝"),
    USER_CANCEL(4, "用户取消售后"),
    WAIT_USER_UPLOAD_EXPRESS(5, "等待用户上传单号"),
    WAIT_MERCHANT_RECEIVE(6, "等待商家收货"),
    REFUND(7, "已退款"),
    MERCHANT_REJECT(8, "商家拒绝"),
    SYSTEM_CANCEL(9, "系统取消售后"),
    ;

    /**
     * 可以申请售后的状态集合
     */
    public static final List<Integer> CAN_APPLY_STATUS_LIST = Arrays.asList(
            AUDIT_FAIL.getStatus(),
            USER_CANCEL.getStatus(),
            MERCHANT_REJECT.getStatus(),
            SYSTEM_CANCEL.getStatus()
    );

    /**
     * 处理中的状态集合
     */
    public static final List<Integer> PROCESSING_STATUS_LIST = Arrays.asList(
            WAIT_AUDIT.getStatus(),
            AUDIT_SUCCESS.getStatus(),
            WAIT_USER_UPLOAD_EXPRESS.getStatus(),
            WAIT_MERCHANT_RECEIVE.getStatus()
    );

    private final Integer status;
    private final String desc;
}
