package cn.com.duiba.live.clue.service.api.remoteservice.agent;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.agent.LiveAgentInviteAuthDto;

import java.util.List;

/**
 * 直播代理人邀请权限
 * @author xuzhigang
 * @date 2021-03-05
 */
@AdvancedFeignClient
public interface RemoteLiveAgentInviteAuthApiService {

    //====================增删改====================

    /**
     * 新增
     *
     * @param dto 代理人直播邀请权限
     * @return 执行结果
     */
    int insert(LiveAgentInviteAuthDto dto);

    //====================查询====================

    /**
     * 根据直播id和代理人id查询代理人权限
     * @param liveId 直播id
     * @param agentId 代理人id
     * @return 代理人直播邀请权限
     */
    LiveAgentInviteAuthDto selectByLiveIdAndAgentId(Long liveId, Long agentId);

    /**
     * 根据直播id集合和代理人id批量查询
     *
     * @param liveIds 直播id集合
     * @param agentId 代理人id
     * @return 配置信息集合
     */
     List<Long> selectLiveIdsByLiveIdsAndAgentId(List<Long> liveIds, Long agentId);

    /**
     * 根据agentId集合和直播id批量查询
     *
     * @param liveId 直播id
     * @param agentIds 代理人id集合
     * @return 配置信息集合
     */
    List<LiveAgentInviteAuthDto> selectListByLiveIdAndAgentIds(Long liveId, List<Long> agentIds);

    /**
     * 查询有权限的代理人id集合
     * @param liveId 直播id
     * @param agentIds 代理人id集合
     * @return 代理人id集合
     */
    List<Long> selectAgentIdsByLiveIdAndAgentIds(Long liveId, List<Long> agentIds);

    /**
     * 根据工号和直播id查询已有权限的代理人
     * @param liveId 直播id
     * @param jobNumbers 工号
     * @return 代理人直播邀请权限
     */
    List<LiveAgentInviteAuthDto> selectByLiveIdAndJobNumbers(Long liveId, List<String> jobNumbers);

    /**
     * 根据直播用户id和直播id查询已有权限的代理人
     * @param liveId 直播id
     * @param liveUserIds 直播用户id
     * @return 有权限的直播用户id
     */
    List<Long> selectLiveUserIdsByLiveIdAndLiveUserIds(Long liveId, List<Long> liveUserIds);
}
