package cn.com.duiba.live.clue.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.order.LiveRefundRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/10/18 18:03
 * @descprtion 退款记录RPC接口
 **/
@AdvancedFeignClient
public interface RemoteLiveRefundRecordApiService {

    /**
     * 新增
     *
     * @param recordDto 记录
     * @return 新增结果
     */
    int insert(LiveRefundRecordDto recordDto);

    /**
     * 根据用户Id以及权益Id获取退款记录
     *
     * @param liveUserId 直播用户Id
     * @param confIds    权益Id集合
     * @return 退款记录列表
     */
    List<LiveRefundRecordDto> listByLiveUserAndConfIds(Long liveUserId, List<Long> confIds);

    /**
     * 根据订单Id查询退款记录
     *
     * @param orderId 订单Id
     * @return 退款记录列表
     */
    List<LiveRefundRecordDto> findByOrderId(Long orderId);

    /**
     * 根据订单Id获取退款记录
     *
     * @param orderIds 权益Id集合
     * @return 退款记录列表
     */
    List<LiveRefundRecordDto> listByOrderIds(List<Long> orderIds);

    /**
     * 根据退款单号查询退款记录
     *
     * @param bizRefundNo 退款单号
     * @return 退款记录
     */
    LiveRefundRecordDto findByBizRefundNo(String bizRefundNo);

    /**
     * 更新退款状态
     *
     * @param bizRefundNo 退款单号
     * @param status      退款状态
     * @param oldStatus   旧的退款状态
     * @return 更新结果
     */
    int updateStatusByBizRefundNo(String bizRefundNo, Integer status, Integer oldStatus);

    /**
     * 更新退款成功收单状态
     *
     * @param bizRefundNos 退款单号
     * @return 更新结果
     */
    int updateSuccessAcceptStatusByBizRefundNos(List<String> bizRefundNos);

    /**
     * 退款成功 更新成功状态以及退款成功时间
     *
     * @param bizRefundNo 退款单号
     * @param refundTime  退款时间
     * @return 更新结果
     */
    int updateSuccessStatusByBizRefundNo(String bizRefundNo, Date refundTime);

    /**
     * 退款失败 更新失败状态
     *
     * @param bizRefundNo 退款单号
     * @return 更新结果
     */
    int updateFailStatusByBizRefundNo(String bizRefundNo);

}
