package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订单地址信息
 *
 * @author xuzhigang
 * @date 2022/8/16 10:40 下午
 **/
@Data
public class MallOrderAddressInfoDto implements Serializable {
    private static final long serialVersionUID = -3778874671073644334L;

    /**
     * 主键Id
     */
    private Long id;

    /**
     * 收货人姓名
     */
    private String receiverName;

    /**
     * 收货人手机号
     */
    private String phoneNum;

    /**
     * 行政区划名称链路 ( 省 -> 市 -> 区 -> 街道 )
     */
    private List<String> adNames;

    /**
     * 具体地址
     */
    private String detailInfo;

    /**
     * 是否是默认地址
     * 0-不是 1-是
     */
    private Integer defaultAddress;
}
