package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商城-订单扩展表
 *
 * @author kjj mybatis generator
 * 2022-08-09
 */
@Data
public class MallOrderExtraDto implements Serializable {
    private static final long serialVersionUID = 16600173182501781L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商城订单id tb_mall_order.id
     */
    private Long orderId;

    /**
     * 页面来源
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderPageSourceEnum}
     */
    private Integer pageSource;

    /**
     * 库存回退标志
     * 0-未回退 1-已回退
     */
    private Integer stockRollbackMark;

    /**
     * 商品快照json
     * {@link MallOrderGoodsSnapDto}
     */
    private MallOrderGoodsSnapDto goodsSnap;

    /**
     * 收货信息json
     * {@link MallOrderAddressInfoDto}
     */
    private MallOrderAddressInfoDto addressInfo;

    /**
     * 物流信息jsonArray
     * {@link MallOrderExpressInfoDto}
     */
    private List<MallOrderExpressInfoDto> expressInfo;
}