package cn.com.duiba.live.clue.service.api.enums.mall.address;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2022/08/09 14:01
 * @description 商城 - 用户地址来源
 */
@Getter
@AllArgsConstructor
public enum MallAddressSourceType {

    /**
     * 经纬度信息来自微信
     * <a href="https://developers.weixin.qq.com/miniprogram/dev/api/location/wx.chooseLocation.html"/>
     */
    LOCATION_INFO(1, "经纬度计算"),

    /**
     * 能获取四级行政区划
     * <a href="https://developers.weixin.qq.com/miniprogram/dev/api/open-api/address/wx.chooseAddress.html">...</a>
     */
    WECHAT_ADDRESS(2, "微信收货地址导入"),
    ;

    private final Integer type;
    private final String desc;
}
