package cn.com.duiba.live.clue.service.api.enums.third.bank.cardapply;

import java.util.Objects;
import lombok.Getter;

/**
 * 银行卡申卡状态
 * @author ouyang
 * @date 2022/6/25 5:03 下午
 */
@Getter
public enum ApplyCardStatusEnum {
    APPLY_START(-1, "开始申请"),
    APPLY_GIFT(0, "核卡"),
    ;


    private final Integer status;

    private final String desc;

    ApplyCardStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static ApplyCardStatusEnum getByType(Integer type) {
        for (ApplyCardStatusEnum typeEnum : ApplyCardStatusEnum.values()) {
            if (Objects.equals(typeEnum.getStatus(), type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
