package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveClueRewardDto;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveClueRewardSimpleIdDto;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveClueRewardVisitorIdDto;
import cn.com.duiba.live.clue.service.api.param.clue.LiveCLueRewardFindParam;
import cn.com.duiba.live.clue.service.api.param.clue.LiveClueRewardSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 直播线索-奖励领取记录remote
 * @author lizhi
 * @date 2021/1/5 3:27 下午
 */
@AdvancedFeignClient
public interface RemoteLiveClueRewardApiService {

    //====================增删改====================

    /**
     * 新增
     * @param dto 直播线索-奖励领取记录
     * @return 主键
     */
    Long insert(LiveClueRewardDto dto);

    /**
     * 批量插入
     * @param list 直播线索-奖励领取记录集合
     * @return 执行结果
     */
    List<LiveClueRewardVisitorIdDto> batchInsert(List<LiveClueRewardDto> list);

    /**
     * 批量插入，并以 confId+liveVisitorId 为key，将结果写入redis
     * @param list 直播线索-奖励领取记录集合
     * @param days redis缓存天数
     * @return 执行结果
     */
    List<LiveClueRewardVisitorIdDto> batchInsertAndWriteRedis(List<LiveClueRewardDto> list, long days);

    //====================访客业务查询====================

    /**
     * 批量查询redis中是否有缓存，key：confId+liveVisitorId
     * 请与batchInsertAndWriteRedis配合使用
     * @param confUsersMap key：confId，value：liveVisitorId集合
     * @return key：confId，key：liveVisitorId，value：是否存在缓存
     */
    Map<Long, Map<Long, Boolean>> existsInRedis(Map<Long, Set<Long>> confUsersMap);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播线索-奖励领取记录
     */
    LiveClueRewardDto selectById(Long id);

    /**
     * 查询代理人ID，直播ID等
     * @param ids 主键集合
     * @return 代理人ID，直播ID等
     */
    List<LiveClueRewardSimpleIdDto> findSimpleIdListByIds(List<Long> ids);

    /**
     * 查询一个用户的领取记录
     * @param param 直播+福利ID+福利类型+用户ID 组成的唯一索引
     * @return 领取记录
     */
    LiveClueRewardDto findUserReceiveRecord(LiveCLueRewardFindParam param);

    /**
     * 查询一个用户的爆款领取记录
     * @param param 直播+用户ID （爆款福利一场直播只能领取一次）
     * @return 爆款福利
     */
    LiveClueRewardDto findUserBoomReceiveRecord(LiveCLueRewardFindParam param);

    /**
     * 批量查询用户领取数量
     * @param liveId 直播id
     * @param liveVisitorIdList 直播用户ID集合
     * @param confId 直播互动配置id
     * @return key：用户ID，value：领取数量
     */
    Map<Long, Long> findUsersReceiveCount(Long liveId, List<Long> liveVisitorIdList, Long confId);

    /**
     * 批量查询用户领取数量
     * @param liveId 直播id
     * @param liveVisitorIdList 直播用户ID集合
     * @param rewardType 福利类型
     * @return key：用户ID，value：领取数量
     */
    Map<Long, Long> findUsersReceiveCountByType(Long liveId, List<Long> liveVisitorIdList, Integer rewardType);

    /**
     * 批量查询用户中奖次数（不包含代理人指定中奖）
     * @param liveId 直播id
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：用户ID，value：中奖次数
     */
    Map<Long, Long> findUsersLotteryCountNonAgentSpecify(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 批量查询用户领取记录ID
     * @param liveId 直播id
     * @param liveVisitorIdList 直播用户ID集合
     * @param rewardType 福利类型
     * @return key：用户ID，value：领取记录ID集合
     */
    Map<Long, List<Long>> findUsersReceiveIdListByType(Long liveId, List<Long> liveVisitorIdList, Integer rewardType);

    /**
     * 获取用户领取权益ID
     * @param liveId 直播id
     * @param liveVisitorIdList 直播访客用户id集合
     * @param rewardType 类型
     * @return key：访客用户id value：权益id
     */
    @Deprecated
    Map<Long, Long> getUserReceiveRewardId(Long liveId, List<Long> liveVisitorIdList, Integer rewardType);

    /**
     * 获取用户领取权益ID
     * @param liveId 直播id
     * @param liveVisitorIdList 直播访客用户id集合
     * @return key：访客用户id value：权益id
     */
    Map<Long, List<Long>> getUserLotteryReceiveRewardId(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 获取用户中奖的配置id
     * @param liveId 直播id
     * @param liveVisitorIds 直播访客用户id
     * @return key：直播用户id value：中奖的配置id
     */
    @Deprecated
    Map<Long, Long> getUserReceiveConfId(Long liveId, Set<Long> liveVisitorIds);

    /**
     * 获取用户中奖的配置id
     * @param liveId 直播id
     * @param liveVisitorIds 直播访客用户id
     * @return key：直播用户id value：中奖的配置id集合
     */
    Map<Long, List<Long>> getUserLotteryReceiveConfId(Long liveId, Set<Long> liveVisitorIds);

    /**
     * 查询领取记录代理人ID
     * @param ids 主键
     * @return key：主键，value：代理人ID
     */
    Map<Long, Long> findAgentIdMap(List<Long> ids);

    //====================代理人业务查询====================

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播线索-奖励领取记录集合
     */
    List<LiveClueRewardDto> selectPage(LiveClueRewardSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播线索-奖励领取记录集合
     */
    List<LiveClueRewardDto> selectList(LiveClueRewardSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveClueRewardSearchParam param);

    /**
     * 根据权益ID及类型，查询线索记录的最大ID
     * @param rewardId 权益ID
     * @param rewardType 权益类型
     * @return 线索最大ID
     */
    Long selectMaxId(Long rewardId, Integer rewardType);

    /**
     * 查询福利领取数量
     * @param rewardIdList 福利ID集合
     * @return key：权益ID（rewardId），value：权益领取数量
     */
    @Deprecated
    Map<Long, Long> findRewardCount(List<Long> rewardIdList);

    /**
     * 查询奖品id
     *
     * @param ids 主键
     * @return key:主键，value：奖品id
     */
    Map<Long, Long> findRewardIdMap(List<Long> ids);


    /**
     * 根据主键查询奖励领取列表
     * @param ids
     * @return 奖励领取记录列表
     */
    List<LiveClueRewardDto> selectByIds(List<Long> ids);

    /**
     * 根据主键查询奖励领取列表
     * @param liveIds 直播id列表
     * @param agentId 代理人id
     * @param liveUserId 访客id
     * @param rewardTypes 奖励类型集合
     * @return 奖励领取记录列表
     */
    List<LiveClueRewardDto> findByLiveIdsAgentIdLiveUserId(List<Long> liveIds, Long agentId, Long liveUserId, List<Integer> rewardTypes);

}
