package cn.com.duiba.live.clue.service.api.remoteservice.evaluation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.evaluation.LiveUserEvaluationRecordDto;
import cn.com.duiba.live.clue.service.api.dto.evaluation.LiveUserIdAndRecordIdDto;

import java.util.List;

/**
 * 测评提交记录rpc
 *
 * @author xuzhigang
 * @date 2021/9/1 8:54 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveUserEvaluationRecordService {
    /**
     * 批量插入测评提交记录
     *
     * @param list 提交记录
     * @return 执行结果
     */
    List<LiveUserIdAndRecordIdDto> batchInsert(List<LiveUserEvaluationRecordDto> list);

    /**
     * 根据直播id 直播用户id查询测评提交记录
     *
     * @param liveId     直播id
     * @param liveUserId 直播用户id
     * @return 测评提交记录集合
     */
    List<LiveUserEvaluationRecordDto> selectByLiveIdAndLiveUserIds(Long liveId, Long liveUserId);

    /**
     * 通过直播id,直播用户id,测评id查询测评提交记录
     *
     * @param liveId       直播id
     * @param liveUserId   直播用户id
     * @param evaluationId 测评id
     * @return 用户提交的对应记录
     */
    LiveUserEvaluationRecordDto selectByParams(Long liveId, Long liveUserId, Long evaluationId);
}
