package cn.com.duiba.live.clue.service.api.remoteservice.voucher;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.voucher.LiveUserVoucherDto;
import cn.com.duiba.live.clue.service.api.param.common.PageQuery;

import java.util.List;

/**
 * 用户代金券
 *
 * @author xuzhigang
 * @date 2022/1/27 10:44 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveUserVoucherService {
    /**
     * 查询赠送列表
     *
     * @param agentId   代理人id
     * @param voucherId 代金券id
     * @param pageQuery 分页参数
     * @return 赠送列表
     */
    List<LiveUserVoucherDto> selectGiftList(Long agentId, Long voucherId, PageQuery pageQuery);

    /**
     * 查询已赠送列表
     *
     * @param agentId     代理人id
     * @param voucherId   代金券id
     * @param liveUserIds 用户id集合
     * @return 已赠送列表
     */
    List<LiveUserVoucherDto> selectHasGiftedList(Long agentId, Long voucherId, List<Long> liveUserIds);

    /**
     * 新增
     *
     * @param dto 用户代金券
     * @return 执行结果
     */
    int insert(LiveUserVoucherDto dto);

    /**
     * 更新
     *
     * @param dto 用户代金券
     * @return 执行结果
     */
    int update(LiveUserVoucherDto dto);

    /**
     * 查询未赠送的代金券（优先查询先创建的）
     *
     * @param agentId 代理人id
     * @param voucherId 代金券id
     * @return 代金券
     */
    LiveUserVoucherDto selectUnGiftedVoucher(Long agentId, Long voucherId);

    /**
     * 批量新增
     *
     * @param list 用户代金券
     * @return 执行结果
     */
    int batchInsert(List<LiveUserVoucherDto> list);

    /**
     * 查询用户代金券
     *
     * @param voucherId 代金券id
     * @param liveUserId 直播用户id
     * @return 代金券
     */
    LiveUserVoucherDto selectUserVoucher(Long voucherId, Long liveUserId);

    /**
     * 批量领取代金券
     *
     * @param list 代金券
     * @return 结果
     */
    int batchUserAcceptVoucher(List<LiveUserVoucherDto> list);

    /**
     * 批量使用代金券
     *
     * @param list 代金券
     * @return 结果
     */
    int batchUserUseVoucher(List<LiveUserVoucherDto> list);
}
