package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LivePassAnswerRecordDto;
import cn.com.duiba.live.clue.service.api.enums.clue.LivePassAnswerResultEnum;

import java.util.List;

/**
 * 直播闯关答题记录remote
 * @author zhanghuifeng
 * @date 2021/6/23 14:20
 */
@AdvancedFeignClient
public interface RemoteLivePassAnswerRecordService {

    /**
     * 批量新增答题记录
     * @param list 线索
     * @return 执行结果
     */
    int batchInsert(List<LivePassAnswerRecordDto> list);

    /**
     * 根据答题结果查询已经回答过的用户
     * @param liveId 直播ID
     * @param questionId 问题ID
     * @param liveUserIds 访客ID
     * @param answerResult  回答结果 {@link LivePassAnswerResultEnum}
     * @return 已经回答过的用户ID
     */
    List<Long> findLiveUserIdByLiveIdAndQuestionIdAndResult(Long liveId, Long questionId,
                                                            List<Long> liveUserIds, Integer answerResult);

    /**
     * 根据直播id和直播用户id查询答题记录（最多返回100条）
     * @param liveId     直播id
     * @param liveUserId 直播用户id
     * @return 答题记录
     */
    List<LivePassAnswerRecordDto> listByLiveIdAndUserId(Long liveId, Long liveUserId);
}
