package cn.com.duiba.live.clue.service.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 支付渠道
 *
 * @author xuzhigang
 * @date 2022/8/9 11:06 上午
 **/
@Getter
@AllArgsConstructor
public enum PayChannelEnum {

    WECHAT_LITE(1, "微信小程序支付"),

    UNION_PAY_FQSD(2, "银联趣分期"),

    CITIC_PAY(3, "中信全付通"),
    ;

    private final Integer code;

    private final String desc;

    /**
     * 支付渠道Map
     */
    private static final Map<Integer, PayChannelEnum> map = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(PayChannelEnum::getCode, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据code获取支付渠道描述
     */
    public static PayChannelEnum getByCode(Integer code) {
        return map.get(code);
    }
}
