package cn.com.duiba.live.clue.service.api.enums.third.bank.cardhold;

import java.util.Objects;
import lombok.Getter;

/**
 * @author ouyang
 * @date 2022/8/17 4:07 下午
 */
@Getter
public enum CardHolderTypeEnum {
    CARD_HOLDER_NBCB(1, "NBCB_CREDIT","宁波银行"),
    CARD_HOLDER_CITIC(2, "CITIC_CREDIT","中信信用卡中心"),
    CARD_HOLDER_CMB(3, "CMB_CREDIT","招商银行"),
    CARD_HOLDER_HXB(4, "HXB_CREDIT","华夏银行"),
    CARD_HOLDER_TL(5, "ZJTLCB_CREDIT","泰隆银行"),
    CARD_HOLDER_JS(6, "JSCB_CREDIT","江苏银行"),
    CARD_HOLDER_ICBC_FJ(7, "CARD_HOLDER_ICBC_FJ","工商银行_福建")



    ;
    /**
     * 场景类型
     */
    private Integer type;

    /**
     * 信用卡类型
     * cn.com.duiba.kjy.api.api.enums.wechat.coupon.WxPayBankTypeEnum bankType
     */
    private String card;

    /**
     * 描述
     */
    private String decs;

    CardHolderTypeEnum(Integer type, String card, String decs) {
        this.type = type;
        this.card = card;
        this.decs = decs;
    }

    public static CardHolderTypeEnum getByType(Integer type) {
        for (CardHolderTypeEnum typeEnum : CardHolderTypeEnum.values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
