package cn.com.duiba.live.clue.service.api.remoteservice.mall.group;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.group.MallGroupRecordDetailDto;

import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2023/5/10 19:13
 **/
@AdvancedFeignClient
public interface RemoteMallGroupRecordDetailService {
    /**
     * 根据用户id和订单id查询拼团明细
     *
     * @param liveUserId 直播用户id
     * @param orderId 订单id
     * @return 拼团明细
     */
    MallGroupRecordDetailDto selectByLiveUserIdAndOrderId(Long liveUserId, Long orderId);

    /**
     * 批量查询
     *
     * @param liveUserId 用户id
     * @param orderIds 订单id集合
     * @return 拼团明细
     */
    List<MallGroupRecordDetailDto> selectListByLiveUserIdAndOrderIds(Long liveUserId, List<Long> orderIds);

    /**
     * 更新拼团明细
     *
     * @param dto 拼团明细
     * @return 执行结果
     */
    int update(MallGroupRecordDetailDto dto);

    /**
     * 新增拼团明细
     * @param dto 拼团明细
     * @return 执行结果
     */
    int insert(MallGroupRecordDetailDto dto);
}
