package cn.com.duiba.live.clue.service.api.remoteservice.mall.group;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.group.MallGroupRecordDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/5/10 19:10
 **/
@AdvancedFeignClient
public interface RemoteMallGroupRecordService {
    /**
     * 根据id查询dto
     *
     * @param id 主键id
     * @return 拼团记录
     */
    MallGroupRecordDto selectById(Long id);

    /**
     * 根据id批量查询Entity
     *
     * @param ids 主键id集合
     * @return 拼团记录
     */
    List<MallGroupRecordDto> selectByIds(List<Long> ids);

    /**
     * 更新
     * @param dto 拼团记录
     * @return 执行结果
     */
    int update(MallGroupRecordDto dto);

    /**
     * 新增
     * @param dto 拼团记录
     * @return 执行结果
     */
    Long insert(MallGroupRecordDto dto);
}
