package cn.com.duiba.live.conf.service.api.dto.live;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播
 * @author kjj mybatis generator
 * @date 2020-04-03
 */
@Data
public class LiveDto implements Serializable {

    private static final long serialVersionUID = 15858825549237393L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 宣传海报
     */
    private String posterUrl;

    /**
     * 福利海报
     */
    private String welfareUrl;

    /**
     * 宣传视频
     */
    private String videoUrl;

    /**
     * 直播标题
     */
    private String title;

    /**
     * 小程序分享图
     */
    private String mpShareUrl;

    /**
     * 小程序分享标题
     */
    private String mpShareTitle;

    /**
     * 直播流ID
     */
    private Long streamId;

    /**
     * 开播时间
     */
    private Date broadcastTime;

    /**
     * 通知时间
     */
    private Date noticeTime;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-直播结束
     */
    private Integer liveStatus;

    /**
     * 互动红包总金额
     */
    private Integer interactionAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 重试次数  重试大于等于3次就不试了 需要人工接入
     */
    private Integer retryTimes;


    /**
     * 小程序二维码
     */
    private String mpQrcode;

    /**
     * 直播间红包总额
     */
    private Integer showRedAmount;

    /**
     * 分享文案
     */
    private String shareContent;

    /**
     * 第二张海报
     */
    private String secondPoster;
}
