package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 区域配置
 * @author lizhi
 * @date 2020/11/12 7:57 下午
 */
@AdvancedFeignClient
public interface RemoteRegionConfApiService {

    /**
     * 查询业务配置的所有省
     * @param bizId 业务ID
     * @return 省集合
     */
    List<Integer> selectProvinceCodeList(Long bizId);

    /**
     * 批量查询业务配置的所有省
     * @param bizIdList 业务ID集合
     * @return key：业务ID，value：省集合
     */
    Map<Long, List<Integer>> batchSelectProvinceCodeList(List<Long> bizIdList);

    /**
     * 根据业务ID批量删除后批量新增
     * @param bizId 业务ID
     * @param provinceCodeList 省集合
     * @return 执行结果
     */
    int batchDeleteAndInsert(Long bizId, List<Integer> provinceCodeList);

}
