package cn.com.duiba.live.conf.service.api.remoteservice.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.sign.LiveIncrStaffSignConfigDto;

/**
 * @author linjianhui
 * @date 2021/3/28 00:50
 * @Description 直播增员签到配置
 */
@AdvancedFeignClient
public interface RemoteLiveIncrStaffSignConfigService {

    /**
     * 新增直播增员签到配置
     * @param dto 签到配置
     * @return 配置对应主键id
     */
    Long insert(LiveIncrStaffSignConfigDto dto);

    /**
     * 编辑直播增员签到配置
     * @param dto 签到配置
     * @return 变更的条数
     */
    Integer update(LiveIncrStaffSignConfigDto dto);

    /**
     * 通过主键id查询签到配置
     * @param id 主键id
     * @return 签到配置
     */
    LiveIncrStaffSignConfigDto findById(Long id);

}
