package cn.com.duiba.live.conf.service.api.enums;

/**
 * @author lizhi
 * @date 2021/1/7 4:21 下午
 */
public enum RedisKeyClueCenterFactory {
    LC012("答题领奖品,奖品库存"),
    LC020("宝箱实物库存"),
    LC143("直播宝箱红包库存"),
    ;

    private static final String SPACE = "LiveClueCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyClueCenterFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
