package cn.com.duiba.live.conf.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Set;

/**
 * Created by dugq on 2020-06-28.
 */
@AdvancedFeignClient
public interface RemoteLiveBannedSpokeApiService {
    /**
     * 禁言
     * @param liveId
     * @param liveUserId
     */
    void bannedSpoke(Long liveId, Long liveUserId);

    /**
     * 放开禁言
     * @param liveId
     * @param liveUserId
     */
    void releaseBannedSpoke(Long liveId, Long liveUserId);

    /**
     * 判断用户是否被禁言
     * @param liveId
     * @param liveUserId
     * @return
     */
    boolean isBannedSpoke(Long liveId, Long liveUserId);

    /**
     * 查询禁言的用户列表
     * @param liveId 直播ID
     */
    Set<Long> getBannedUserList(Long liveId);

    /**
     * 批量判断用户是否禁言
     * @return 被禁言的用户
     */
    Set<Long> getBannedSpokeList(Long liveId, List<Long> liveUserIds);
}
