package cn.com.duiba.live.conf.service.api.remoteservice.treasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.treasure.LiveTreasureConfRelatedDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-04-19 20:12
 * 宝箱关联表-rpc接口
 */
@AdvancedFeignClient
public interface RemoteLiveTreasureRelatedApiService {

    /**
     * 通过宝箱id列表获取宝箱关联表列表
     * @param confIds 宝箱id列表
     * @return 宝箱关联表列表
     */
    List<LiveTreasureConfRelatedDto> listByConfIds(List<Long> confIds);

    /**
     * 批量插入宝箱关联列表
     * @param liveTreasureConfRelatedList 宝箱关联列表
     * @return 宝箱关联id列表
     */
    List<Long> batchInsert(List<LiveTreasureConfRelatedDto> liveTreasureConfRelatedList);

    /**
     * 批量修改宝箱关联列表
     * @param liveTreasureConfRelatedList 宝箱关联列表
     * @return 宝箱关联id列表
     */
    boolean batchUpdate(List<LiveTreasureConfRelatedDto> liveTreasureConfRelatedList);

    /**
     * 逻辑删除宝箱关联表
     * @param id 宝箱关联表
     * @return 删除结果
     */
    boolean logicDelete(Long id);

    /**
     * 根据主键查询
     * @param id 主键 tb_live_treasure_conf_related.id
     * @return 直播宝箱关联配置信息
     */
    LiveTreasureConfRelatedDto selectById(Long id);
}
