package cn.com.duiba.live.conf.service.api.param.treasure;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播前宝藏福利中奖率配置
 * @author kjj mybatis generator 
 * @date 2021-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveTreasureConfRelatedSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16181926127143679L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 宝藏配置Id tb_live_pre_treasure_conf.id
     */
    private Long treasureConfId;

    /**
     * 宝箱类型 1:抽奖码 2:现金红包 3:实物奖品
     */
    private Byte treasureType;

    /**
     * 业务方ID
     */
    private Long bizConfId;

    /**
     * 发放抽奖码数量类型 1:固定数量, 2:随机数量
     */
    private Byte ruleType;

    /**
     * 固定(数量/金额)、最小(数量/金额)
     */
    private Integer fixedNum;

    /**
     * 最大(数量/金额)
     */
    private Integer maxNum;

    /**
     * 福利总数
     */
    private Integer totalNum;

    /**
     * 概率 百分制
     */
    private Byte probability;

    /**
     * 0:未删除 1:已删除
     */
    private Byte logicDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}