package cn.com.duiba.live.conf.service.api.dto.treasure.redis;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhuenhui
 * @date 2021/04/16 08:43 下午
 * @description 红包简单对象
 */
@Data
@Builder
public class TreasureRedSimpleDto implements Serializable {

    private static final long serialVersionUID = -1321620302914619428L;

    /**
     * 发放抽奖码数量类型 1:固定数量, 2:随机数量
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureCodeRuleTypeEnum
     */
    private Integer ruleType;

    /**
     * 红包金额
     * 1. 固定金额: 展示固定金额
     * 2. 随机金额: 展示最高红包金额
     */
    private Integer redTotalAmount;

    /**
     * 业务方ID
     */
    private Long bizConfId;
}
