package cn.com.duiba.live.conf.service.api.remoteservice.quesreward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.ques.LiveQuesRewardConfDto;
import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import cn.com.duiba.live.conf.service.api.param.ques.LiveQuesRewardConfEditParam;

import java.util.List;

/**
 * 直播答题领奖配置api接口
 * @author 吴文哲
 * @date 2021/3/22 7:12 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveQuesRewardConfApiService {

    /**
     * 查询当前直播间最近一条 deleted=0 的直播答题领奖配置信息 按照id正序
     * @param liveId 直播间id
     * @param status 状态
     * @return 直播答题领奖配置主键id
     */
    Long getLastByLiveId(Long liveId, List<Integer> status);

    /**
     * 根据直播间Id + 分页参数 查询当前直播间deleted=0的直播答题领奖配置列表 按照id正序
     * @param liveId 直播间id
     * @param pageQuery 分页信息
     * @return 直播答题领奖配置列表
     */
    List<LiveQuesRewardConfDto> getListByLiveId(Long liveId, PageQuery pageQuery);

    /**
     * 根据主键id查询 过滤掉deleted=1的数据
     * @param confId 配置主键id
     * @return 直播答题领奖配置信息
     */
    LiveQuesRewardConfDto getById(Long confId);

    /**
     * 新增直播答题领奖配置,同时按照rewardType不同,配置
     * 新增成功后 领奖配置 都需要在service写入redis 缓存7天,便于live-clue-web在直播间查询
     * 新增redis缓存 LiveQuesRewardConfDto 保存7天
     * 新增库存Redis缓存  Long 类型 保存7天
     * @param dto 新增参数
     * @return 新增结果
     */
    boolean saveLiveQuesRewardConfDto(LiveQuesRewardConfEditParam dto);

    /**
     * 新增直播答题领奖配置,同时按照rewardType不同,配置
     * 刷新redis缓存 LiveQuesRewardConfDto 保存7天
     * 刷新库存Redis缓存  Long 类型 保存7天
     * @param dto 修改参数
     * @return 修改结果
     */
    boolean updateLiveQuesRewardConfDto(LiveQuesRewardConfEditParam dto);

    /**
     * 根据主键id删除
     * @param confId 主键id
     * @return 删除结果
     */
    boolean deleteById(Long confId);

    /**
     * 根据直播间id 获取当前已上架 且 未结束的 直播答题领奖配置,写入redis
     * 在上架/发放后调用一次,存到redis中,便于live-clue-web查询,不缓存null
     * 该方法只能由live-conf-web调用,live-clue-web禁用
     * @param confId 配置id
     * @return 直播答题领奖配置详情缓存
     */
    boolean setAvailableQuesRewardConfIntoRedis(Long confId);

    /**
     * 答题有奖问题配置上架(live-conf-web专用)
     * @param id 主键
     * @return 执行结果
     */
    boolean updateStatus2Up(Long id);

    /**
     * 答题有奖问题配置发放中(live-conf-web专用)
     * @param id 主键
     * @return 执行结果
     */
    boolean updateStatus2Open(Long id);

    /**
     * 答题有奖问题设置为结束状态
     * @param id 主键
     * @return 执行结果
     */
    boolean updateStatus2End(Long id);


    /**--------pc端管理后台专用-------------*/

    /**
     * 根据直播id查询列表数据(管理后台专用)
     * @param liveId 直播id
     * @return 列表数据
     */
    List<LiveQuesRewardConfDto> findByLiveId(Long liveId);

    /**--------刷数据使用-------------*/
    /**
     * 批量插入
     * @param confDtoList 插入记录
     * @return 新增结果
     */
    int batchInsert(List<LiveQuesRewardConfDto> confDtoList);
}
