package cn.com.duiba.live.conf.service.api.remoteservice.treasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.treasure.LiveTreasureConfDto;
import cn.com.duiba.live.conf.service.api.dto.treasure.LiveTreasureConfRelatedDto;
import cn.com.duiba.live.conf.service.api.dto.treasure.LiveTreasureSaveDto;

import java.util.List;

/**
 * 直播前宝箱rpc接口
 *
 * @author 吴文哲
 * @date 2021/4/9 10:01 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveTreasureApiService {

    /**
     * 根据主键 查询直播前宝箱配置
     *
     * @param id 主键
     * @return 直播前宝箱配置信息
     */
    LiveTreasureConfDto getTreasureConfById(Long id);

    /**
     * 根据直播间id和场景类型 查询直播前宝箱配置
     *
     * @param liveId            直播间id
     * @param treasureSceneType 宝箱场景类型
     * @return 直播前宝箱配置信息
     */
    LiveTreasureConfDto getTreasureConf4Fission(Long liveId, Integer treasureSceneType);

    /**
     * 根据宝箱配置id 查询 宝箱关联表信息
     *
     * @param treasureConfId 宝箱配置Id tb_live_pre_treasure_conf.id
     * @return 配置关联信息列表
     */
    List<LiveTreasureConfRelatedDto> getConfRelatedByConfId(Long treasureConfId);

    /**
     * 根据宝箱配置id和宝箱类型查询
     *
     * @param treasureConfId 宝箱配置Id tb_live_pre_treasure_conf.id
     * @param type           宝箱类型
     * @return 宝箱相关配置
     */
    LiveTreasureConfRelatedDto getTreasureConfRelatedByConfIdAndType(Long treasureConfId, Integer type);

    /**
     * 根据宝箱配置id列表和奖品类型查询
     * @param treasureConfIds 宝箱配置id列表
     * @param type 宝箱类型
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureTypeEnums
     * @return 宝箱关联数据
     */
    List<LiveTreasureConfRelatedDto> getTreasureConfRelatedByConfIdsAndType(List<Long> treasureConfIds,Integer type);

    /**
     * 新增直播前宝箱配置
     * 使用数据库事务保证数据一致性
     *
     * @param saveDto 保存对象
     * @return 新增结果
     */
    boolean insertLivePreTreasureConf(LiveTreasureSaveDto saveDto);

    /**
     * 修改直播前宝箱配置
     * 使用数据库事务保证数据一致性
     *
     * @param saveDto 保存对象
     * @return 修改结果
     */
    boolean updateLivePreTreasureConf(LiveTreasureSaveDto saveDto);

    /**
     * 根据直播间id 刷新直播前宝箱配置信息缓存
     *
     * @param liveId 直播间id
     * @return 刷新redis结果
     */
    boolean refreshLivePreTreasureConf(Long liveId);

    /**
     * 开启 / 关闭宝箱
     *
     * @param liveId             直播Id
     * @param treasureScene      宝箱场景
     * @param treasureConfStatus 宝箱状态
     * @return 执行结果
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureSceneTypeEnum
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureConfStatusEnum
     */
    boolean switchStatus(Long liveId, Integer treasureScene, Integer treasureConfStatus);

    /**
     * 根据直播间id和场景类型 查询宝箱配置
     *
     * @param liveId            直播间id
     * @param treasureSceneType 宝箱场景类型
     * @return 宝箱配置信息
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureSceneTypeEnum
     */
    List<LiveTreasureConfDto> listConfByLidAndType(Long liveId, Integer treasureSceneType);

}
