package cn.com.duiba.live.conf.service.api.dto.livestream;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿里云app录制记录
 * @author kjj mybatis generator
 * 2020-03-27
 */
@Data
public class TranscribeRecordDto implements Serializable {
    private static final long serialVersionUID = 15852889338277772L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *app域名
     * max length = 50
     * not null default = null
     */
    private String domainName;

    /**
     *
     *直播app的ID
     * not null default = null
     */
    private Long appId;

    /**
     *
     *直播记录ID
     * not null default = null
     */
    private Long streamId;

    /**
     *
     *录制成功后存的oss地址
     * max length = 255
     * 说明：本字段就是录制文件的地址。由于第一版做的是阿里云的直播，阿里云存于oss。所以此处命名和阿里云文档相同【objectName】
     *      在接入腾讯云后，文件地址也存于此字段。
     */
    private String objectName;

    /**
     *
     *录制视频的时长
     */
    private Double duration;

    /**
     *
     *是否录制成功 0:false 1:true
     * not null default = 1
     */
    private Integer status;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 视频大小
     */
    private Integer videoSize;
}
