package cn.com.duiba.live.conf.service.api.dto.treasure;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播宝藏福利配置表
 *
 * @author kjj mybatis generator
 * @date 2021-04-12
 */
@Data
public class LiveTreasureConfDto implements Serializable {

    private static final long serialVersionUID = 16181985548199849L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 宝箱场景(业务维度) 1:直播前宝箱 2:直播中宝箱
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureSceneTypeEnum
     */
    private Integer treasureScene;

    /**
     * 宝箱排序，默认为1
     */
    private Integer treasureSort;

    /**
     * 宝箱周期，1仅直播前，2仅直播中，3直播前和直播中
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasurePeriodTypeEnum
     */
    private Integer treasurePeriod;

    /**
     * 宝箱最大开启次数
     */
    private Integer openNum;

    /**
     * 0:关闭,1:开启
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 宝箱开启条件，scene:1邀请人数，scene:2观看时长
     */
    private Integer openCondition;

}