package cn.com.duiba.live.conf.service.api.dto.treasure;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播前宝藏福利中奖率配置
 *
 * @author kjj mybatis generator
 * @date 2021-04-12
 */
@Data
public class LiveTreasureConfRelatedDto implements Serializable {

    private static final long serialVersionUID = 16181926127119680L;

    //  ---------- 通用字段 ----------

    /**
     * 主键
     */
    private Long id;

    /**
     * 宝箱配置Id tb_live_treasure_conf.id
     */
    private Long treasureConfId;

    /**
     * 宝箱类型 1:抽奖码 2:现金红包 3:实物奖品
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureTypeEnums
     */
    private Integer treasureType;

    /**
     * 业务方ID
     */
    private Long bizConfId;

    /**
     * 发放抽奖码数量类型 1:固定数量, 2:随机数量
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureCodeRuleTypeEnum
     */
    private Integer ruleType;

    /**
     * 固定数量/最小数量
     */
    private Integer fixedNum;

    /**
     * 最大数量
     */
    private Integer maxNum;

    /**
     * 福利总数
     */
    private Integer totalNum;

    /**
     * 概率 万分制
     */
    private Integer probability;

    // ---------- 专用字段 ----------

    /**
     * 奖品福利Id，当配置实物奖品时必传
     */
    private Long welfareId;

    /**
     * 宝箱红包总金额
     */
    private Integer redTotalAmount;

}