package cn.com.duiba.live.conf.service.api.enums.live;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 直播分享类型枚举
 *
 * @author xuzhigang
 * @date 2020/8/8 3:09 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveShareTypeEnum {
    MP_SHARE(1, "普通小程序分享"),

    RED_MP_SHARE(2, "红包小程序分享"),

    PRE_LOTTERY_MP_SHARE(3, "直播前抽奖分享");

    private Integer type;

    private String desc;

    /**
     * 校验是否是小程序分享
     *
     * @param shareType 分享类型
     * @return true-是小程序分享 false-不是小程序分享
     */
    public static boolean isMpShare(Integer shareType) {
        return Objects.equals(shareType, MP_SHARE.type) || Objects.equals(shareType, RED_MP_SHARE.type) || Objects.equals(shareType, PRE_LOTTERY_MP_SHARE.type);
    }
}
