package cn.com.duiba.live.conf.service.api.dto.ques;

import cn.com.duiba.live.conf.service.api.dto.ques.red.LiveQuesRedDetailCacheDto;
import cn.com.duiba.live.conf.service.api.dto.ques.welfare.LiveQuesWelfareDetailCacheDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播答题领奖配置详情缓存
 * @author 吴文哲
 * @date 2021/3/22 11:28 上午
 **/
@Data
public class LiveQuesRewardDetailCacheDto implements Serializable {
    private static final long serialVersionUID = 304567169042249364L;

    /**
     * 答题领奖配置id tb_live_ques_reward_conf.id
     */
    private Long quesConfId;

    /**
     * 奖品类型 1:答题送红包 2:答题送奖品
     * @see cn.com.duiba.live.conf.service.api.enums.conf.QuestionRewardTypeEnum
     */
    private Integer quesType;

    /**
     * 问题详情
     */
    private LiveQuesCacheDto questionDetail;

    /**
     * 红包详情
     */
    private LiveQuesRedDetailCacheDto redDetail;

    /**
     * 奖品详情
     */
    private LiveQuesWelfareDetailCacheDto welfareDetail;

    /**
     * 答题领奖持续时间 单位秒
     */
    private int quesRewardSeconds;

    /**
     * 答题领奖结束时间
     */
    private Date quesRewardEndTime;
}
