package cn.com.duiba.live.conf.service.api.param.treasure;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播宝藏福利配置表
 * @author kjj mybatis generator 
 * @date 2021-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveTreasureConfSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 1618198554820246L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 0:关闭,1:开启
     */
    private Byte confStatus;

    /**
     * 宝箱开启条件,抽奖码数量
     */
    private Integer openCondLotteryCode;

    /**
     * 宝箱红包总金额
     */
    private Integer redTotalAmount;

    /**
     * 宝箱场景 1:直播前宝箱
     */
    private Byte treasureScene;

    /**
     * 0:未删除 1:已删除
     */
    private Byte logicDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}