package cn.com.duiba.live.conf.service.api.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;

/**
 * fast json 序列化 加密
 * @author dugq
 * @date 2020-04-02
 */
public class IdFastJsonSerializable implements ObjectSerializer {

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if(Objects.isNull(object)){
            serializer.write(null);
            return;
        }
        if (object.getClass().isPrimitive() || object instanceof Long){
            serializer.write(IdMakeUtil.encodingId((long)object));
            return;
        }
        serializer.write(null);
    }
}
