package cn.com.duiba.live.conf.service.api.dto.treasure.redis;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhuenhui
 * @date 2021/04/16 8:35 下午
 * @description 直播裂变宝箱Redis缓存
 */
@Data
public class LiveFissionTreasureRedisDto implements Serializable {

    private static final long serialVersionUID = -7705061205366571932L;

    /**
     * 主键id tb_live_pre_treasure_conf.id
     */
    private Long treasureConfId;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 宝箱场景
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasurePeriodTypeEnum
     */
    private Integer treasurePeriod;

    /**
     * 0:关闭,1:开启
     *
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 宝箱开启条件，邀请人数
     */
    private Integer openCondition;

    /**
     * 宝箱最大开启次数
     */
    private Integer openNum;

    /**
     * 抽奖码
     */
    private TreasureCodeSimpleDto treasureCode;

    /**
     * 红包
     */
    private TreasureRedSimpleDto treasureRed;

    /**
     * 实物奖品
     */
    private TreasureAwardSimpleDto treasureAward;

}
