package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveAgentUrlConfDto;

import java.util.List;

/**
 * 直播配置代理人专属链接配置服务rpc类
 */
@AdvancedFeignClient
public interface RemoteLiveAgentCustomUrlConfApiService {

    /**
     * 根据主键查找
     *
     * @param id 主键
     * @return 直播资料配置信息
     */
    LiveAgentUrlConfDto findById(Long id);

    /**
     * 根据直播id和资料id查询代理人配置
     *
     * @param liveId     直播id
     * @param resourceId 资料id
     * @return 直播资料代理人配置，应仅一条
     */
    List<LiveAgentUrlConfDto> findByLiveResourceId(Long liveId, Long resourceId);

    /**
     * 根据直播id与资料id批量查询代理人配置信息
     *
     * @param liveId      直播id
     * @param resourceIds 所有资料id
     * @return 直播资料代理人配置
     */
    List<LiveAgentUrlConfDto> findByLiveResourceIds(Long liveId, List<Long> resourceIds);

    /**
     * 保存或修改代理人配置
     *
     * @param dto 代理人配置信息
     * @return 记录的主键id
     */
    Long saveOrUpdate(LiveAgentUrlConfDto dto);

}
