package cn.com.duiba.live.conf.service.api.enums.innerlog;

/**
 * 内部日志类型
 * @author lizhi
 * @date 2020/4/20 6:01 PM
 */
public enum InnerLogTypeEnum {
    SHARE(1,"分享"),
    ONLINE(2,"在线人数"),
    ENTER(3,"进入直播"),
    OUT(4,"退出直播"),
    SPOKE_LIMITER(5,"评论限流"),
    PUBLIC_LIMITER(6,"公共推送限流"),
    LUCK_TASK(7, "幸运任务"),
    DRAW_TASK(8, "中奖任务"),
    QUESTION_RED_SHARE(9, "答题红包,答错用户分享直播间复活"),
    USER_QUESTION_RED_ANSWER_RESULT(10, "答题红包,用户答题信息"),
    EVENT_TIME(11, "直播事件时间记录"),
    LIVE_NOTICE(12, "直播公告"),
    LIVE_SEND_QUESTION(13, "直播提问"),
    LOTTERY_REGION(14, "抽奖地区校验"),
    LIVE_VISITOR_COUNT(15, "直播间访客人数总数"),
    LIVE_INVITATION_MOVEMENT(16, "代理人邀请迁移"),

    //BI统计指标需要的内部日志
    BI_AGENT_INVITATION(20, "邀请"),
    BI_APPOINTMENT(21, "预约"),
    BI_PRESENT(22, "到场"),
    BI_SHARE(23, "分享"),
    BI_SPOKE(24, "评论"),
    BI_APPOINTMENT_SUBSCRIBE(25, "订阅"),
    BI_RESOURCE_FORM(26, "填写表单"),
    BI_LOTTERY(27, "抽奖中奖"),
    BI_RESOURCE(28, "领取资料"),
    BI_CHOICE(29, "参与投票"),
    BI_QUESTION(30, "提问"),
    BI_FREE_LOTTERY(31, "免费领福利"),
    BI_RED(32, "红包领取记录"),
    BI_RED_RECEIVE(33, "领取红包"),
    BI_RED_HELP(34, "红包助力"),
    BI_RED_PAY_SUCCESS(35, "红包到账"),

    FIRST_WX_QR_CODE_EMPTY(36, "首张海报为空"),
    BI_LIVE_TREASURE(48, "直播宝箱"),

    ;

    private final Integer type;

    private final String desc;

    InnerLogTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
