package cn.com.duiba.live.conf.service.api.dto.livestream;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿里云app截屏配置
 * @author kjj mybatis generator 
 * 2020-03-27
 */
@Data
public class SnapshotConfigDto implements Serializable {
    private static final long serialVersionUID = 15852889338239263L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *直播app的ID
     * not null default = null
     */
    private Long appId;

    /**
     *
     *域名
     * max length = 50
     * not null default = null
     */
    private String domainName;

    /**
     *
     *截图间隔 单位：秒 取值范围5-3600
     * not null default = 5
     */
    private Integer timeInterval;

    /**
     *
     *oss 文件地址，可根据阿里云预留的占位符自由组合
     * max length = 255
     * not null default = picture/{AppName}/{StreamName}.jpg
     */
    private String objectName;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}