package cn.com.duiba.live.conf.service.api.dto.guess;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-05-11 17:06
 * 最新一轮猜数红包信息
 */
@Data
public class LiveLatestGuessRedRedisDto implements Serializable {

    private static final long serialVersionUID = 1510762486275312900L;

    /**
     * 红包id
     */
    private Long confId;

    /**
     * 红包轮次
     */
    private Integer redSort;

    /**
     * 猜数下限
     */
    private Integer guessMinNum;

    /**
     * 猜数上限
     */
    private Integer guessMaxNum;

    /**
     * 最小猜测次数
     */
    private Integer guessLeastTime;

    /**
     * 单个红包金额
     */
    private Integer redAmount;

    /**
     * 红包状态（此处只用到了123，三种状态）
     * @see cn.com.duiba.live.conf.service.api.enums.red.LiveRedPacketStatusEnum
     */
    private Integer redStatus;

    /**
     * 红包展示份数
     */
    private Integer redShowNum;
}
