package cn.com.duiba.live.conf.service.api.dto.guess;

import cn.com.duiba.live.conf.service.api.dto.red.LiveConfRedPacketDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-05-11 16:35
 * 猜数红包组合dto
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class LiveConfRedGuessListDto extends LiveConfRedPacketDto {

    private static final long serialVersionUID = 7261666382727177916L;

    /**
     * 红包轮次
     */
    private Integer redSort;

    /**
     * 猜数下限
     */
    private Integer guessMinNum;

    /**
     * 猜数上限
     */
    private Integer guessMaxNum;

    /**
     * 最小猜测次数
     */
    private Integer guessLeastTime;

    /**
     * 红发发放类型
     * @see cn.com.duiba.live.conf.service.api.enums.live.LiveGuessRedSendTypeEnum
     */
    private Integer sendType;
}
