package cn.com.duiba.live.conf.service.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 直播间配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
@Getter
public enum LiveExtEnum {

    INVITE_COUNT(1, "代理人指定中奖参与条件,邀请个数"),

    PRESENT_NUM(2, "直播到场人数"),

    LOTTERY_ONLY_SPECIFY(3, "暗箱-企业指定中奖人员，其他轮次是否可中奖"),

    LOTTERY_VEST_SPECIFY(4, "暗箱-企业指定中奖人员不足，未指定人员是否可中"),

    @Deprecated
    AWARW_GRANT_CHECK(5,"奖品发放配置-客户确认信息"),

    @Deprecated
    AWARW_GRANT_CHECK_RED(6,"奖品发放配置-客户确认信息红包"),

    @Deprecated
    AWARW_GRANT_ENTRANCE(7,"奖品发放配置-奖品签收入口"),

    AWARW_GRANT_QRCODE_URL(8,"奖品发放配置-奖品签收二维码"),

    MAX_SPECIFY_COUNT(9, "代理人指定中奖次数最大值"),

    @Deprecated
    AWARW_GRANT_SIGN_RED(10,"奖品发放配置-客户签收奖励红包"),

    LOTTERY_DIRECTLY(11, "抽奖-新老客户奖品分配"),

    LOTTERY_DIRECTLY_SCORE(12, "抽奖-新老客户奖品分配加分"),

    LIVE_DELAY_FLAG(13,"直播间延期标记"),

    LIVE_SECOND_VERYTICEL_POSYTER_URL(14,"直播宣传第二张竖版海报链接"),

    AGENT_INVITE_AUTH_TYPE(15, "代理人邀请权限类型"),

    AGENT_INVITE_AUTH_LIMIT_NUM(16, "代理人邀请权限限制人数"),

    AGENT_HAS_JOIN_NUM(17, "代理人已参与人数"),

    GOLD_SYNC_INFO(18, "国寿黄金宝典同步相关信息"),

    @Deprecated
    AWARW_GRANT_AGENT_CHECK_RED(21,"奖品发放配置-代理人确认信息红包"),
	
	SPECIFY_AWARD_PRIVILEGE_SCOPE(22,"指定中奖权限范围"),

    REWARD_AWAY_CHECK_CONF(23, "中奖名单核奖方式"),

    REWARD_RED_PACKET_CONF(24, "中奖名单红包配置"),

    AWARD_GRANT_SCAN_CODE(25, "奖品发放配置-扫码设置"),

    LIVE_RED_RULE(26, "直播答题有奖红包奖品规则"),

    LIVE_WELFARE_RULE(27, "直播答题有奖实物奖品规则"),

    LIVE_REGION_TYPE(28, "直播-指定区域配置"),

    LIVE_DISTRIBUTION_TYPE(29, "直播间奖品分发方式"),

    LIVE_TIMED_CHOICE_SWITCH_CONF(30, "直播间定时投票开关")
    ;

    /**
     * 键  长度限制64
     */
    private Integer key;
    /**
     * 描述  长度限制1024
     */
    private String desc;


    LiveExtEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }


    private static final Map<Integer, LiveExtEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    public static LiveExtEnum getByType(String  key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     * @param key
     * @return
     */
    public static boolean contains(String key){
        if (StringUtils.isBlank(key)){
            return false;
        }
        for (LiveExtEnum enumVal : LiveExtEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

}
