package cn.com.duiba.live.conf.service.api.param.resource;

import cn.com.duiba.live.conf.service.api.enums.resource.ResourceTestClueTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhanghuifeng
 * date 2021/3/1-16:35
 */
@Data
public class ResourceTestSaveParam implements Serializable {

    private static final long serialVersionUID = -8468702828408515571L;

    /**
     * tb_resource表主键ID
     */
    private Long resourceId;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 资源标题
     */
    private String resourceTitle;

    /**
     * 资料图片
     */
    private String resourceImg;

    /**
     * 测试类型：1-增员秒薪
     * @see cn.com.duiba.live.conf.service.api.enums.resource.ResourceTestTypeEnum
     */
    private Integer testType;

    /**
     * 线索类型：1-领取门票 2-发起咨询
     * @see ResourceTestClueTypeEnum
     */
    private Integer clueType;

    /**
     * 公司行业介绍图片,逗号分隔
     */
    private String tradeIntroducePictures;

    /**
     * 悬浮图片
     */
    private String suspendImg;

    /**
     * 主按钮文案
     */
    private String mainButtonTitle;

    /**
     * 营销按钮文案
     */
    private String saleButtonTitle;

    /**
     * 按钮名称
     */
    private String resourceButtonTitle;
}
