package cn.com.duiba.live.conf.service.api.param.pass;

import cn.com.duiba.live.conf.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 闯关答题问题配置表
 * @author kjj mybatis generator 
 * @date 2021-06-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LivePassQuesConfSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16239950283508140L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 0:未开始,1:已发放
     */
    private Integer quesStatus;

    /**
     * 预计答题时间，相对于开播时间后几分钟
     */
    private Integer openTime;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer logicDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}